// Triangulator.h
// Definit la classe de base des triangulateurs d' iso-surfaces
// Un trianguleur doit etre capable de generer un objet 3D (vertices, triangles et normales) a partir d'une isosurface.

#ifndef V3D_BLOBS_TRIANGULATOR_H_INCLUDED
#define V3D_BLOBS_TRIANGULATOR_H_INCLUDED

//#include "IsoSurface.h"
#include "ScanLines.h"
#include "Basics/BoundAabb.h"

namespace V3D {

class IsoSurface;

//////////////////////////////////////////////////////////////////////////////////////////
class Triangulator
{

public:
	Triangulator() {}
	virtual ~Triangulator() {}

	virtual void GenerateMesh( const IsoSurface& iso, 
								Vect3DArray& aVertices, TriangleArray& aTriangles,
								Vect3fArray* paNorms = 0, bool bNormalizeNormals = false ) = 0;
};

//////////////////////////////////////////////////////////////////////////////////////////






} // namespace



#endif	// #ifndef V3D_BLOBS_TRIANGULATOR_H_INCLUDED

